VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DlxOCX32.ocx"
Begin VB.Form Form1 
   Caption         =   "Frequency Measurement with KPCI-3108"
   ClientHeight    =   5910
   ClientLeft      =   2295
   ClientTop       =   1860
   ClientWidth     =   7080
   LinkTopic       =   "Form1"
   ScaleHeight     =   5910
   ScaleWidth      =   7080
   Begin VB.ComboBox cmbDevNum 
      Height          =   315
      Left            =   2880
      TabIndex        =   7
      Text            =   "0"
      Top             =   960
      Width           =   735
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Initialize"
      Height          =   495
      Left            =   600
      TabIndex        =   6
      Top             =   840
      Width           =   1815
   End
   Begin DlsrLib.DriverLINXSR SRCT 
      Left            =   4680
      Top             =   960
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.TextBox txtRate 
      Height          =   285
      Left            =   2880
      TabIndex        =   3
      Text            =   "0"
      Top             =   1920
      Width           =   855
   End
   Begin VB.CommandButton cmdStart 
      Caption         =   "Measure Freq"
      Enabled         =   0   'False
      Height          =   495
      Left            =   600
      TabIndex        =   0
      Top             =   1800
      Width           =   1815
   End
   Begin DlsrLib.DriverLINXSR SRDO 
      Left            =   4680
      Top             =   1680
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label3 
      Caption         =   "Device Number"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   2880
      TabIndex        =   8
      Top             =   600
      Width           =   1215
   End
   Begin VB.Image Image1 
      Height          =   1815
      Left            =   720
      Picture         =   "frm3108Freq.frx":0000
      Top             =   3600
      Width           =   5490
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   "  KEITHLEY  "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   360
      Left            =   600
      TabIndex        =   5
      Top             =   120
      Width           =   1845
   End
   Begin VB.Label label1 
      Caption         =   "Freq (Hz):"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2880
      TabIndex        =   4
      Top             =   1560
      Width           =   975
   End
   Begin VB.Label lblDOStatus 
      BackColor       =   &H8000000E&
      Caption         =   "DO Status"
      Height          =   255
      Left            =   600
      TabIndex        =   2
      Top             =   3000
      Width           =   5295
   End
   Begin VB.Label lblStatus 
      BackColor       =   &H8000000E&
      Caption         =   "Status"
      Height          =   255
      Left            =   600
      TabIndex        =   1
      Top             =   2520
      Width           =   5295
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
' ***********************************************************
' VB6.0 application
' tested with KPCI-3108 with A07 firmware
' using 3108-850A04 driver revision in Win2000 Pro SP1
'**************************************************************
'
' GOAL:  measure frequency using KPCI-3107 or KPCI-3108
'
' Ideally a one shot pulse is applied to gate of a counter and the
' signal of interest is applied to the counter input.  Dividing the
' number of pulses counted during the known amount of gate time
' is a measure of the frequency (pulses/time).
'
' Difficulty is the 82C54 counter/timer chip used on KPCI-3108
' can not generate a one shot pulse.
' Without a one shot, we can not apply a signal to
' the gate of a C/T channel that is not repetitive.
' If we use a repetitive signal such as square wave at the gate,
' then we must have good coordination of when to read the C/T.
' If we are late (or too soon) and the gate signal goes high again (or is
' not yet low), then the counter will resume counting and the measurement is bad.
'
' To combat this limitation of the 82C54, this example generates a one shot pulse
' by use of the digital output.  The pulse width is precise as we use the 82C54 to
' clock out a fixed number of DO values in a fixed amount of time.
' When the DO task is finished, we get a Service Done message, hence, we
' know when to go read the counter.
'
' C/T channel 2 is used to pace the DO task.
' C/T channel 1 is used to do the freq measurement.
'
' Connect OP0 to Gate (pin 24 to pin 19).  Connect the signal of interest to
' pin 20#
Dim DeviceNumber As Integer

Private Sub cmdInit_Click()
' get device number from the form's combo box
DeviceNumber = CInt(cmbDevNum.Text)

' initialize the entire board (DL_DEVICE)
With SRDO
.Req_DLL_name = "kpci3108$"  ' load only the kpci3108 driver
.Req_device = DeviceNumber
.Req_op = DL_INITIALIZE
.Req_mode = DL_OTHER
.Req_subsystem = DL_DEVICE
.Refresh
End With
If SRDO.Res_result <> DL_NoErr Then
lblDOStatus.Caption = "Trouble Initializing your device: " & SRDO.Message
Exit Sub   ' leave this subroutine
Else
lblDOStatus.Caption = "Board Initialized with: " & SRDO.Message
End If


' this example assumes the C/T and the DO are on the same board
SRCT.Req_DLL_name = SRDO.Req_DLL_name
'init the C/T subsystem
With SRCT
.Req_device = DeviceNumber
.Req_op = DL_INITIALIZE
.Req_mode = DL_OTHER
.Req_subsystem = DL_CT
.Refresh
End With
' error check routine
If SRCT.Res_result <> DL_NoErr Then
lblStatus.Caption = "Trouble Initializing C/T Sub-System: " & SRCT.Message
Exit Sub
Else
lblStatus.Caption = "C/T Sub-System Initialized with: " & SRCT.Message
End If


' return focus back to our form
Form1.SetFocus

If SRCT.Req_DLL_name <> "KPCI3108" Then
MsgBox "This example was written for the KPCI-3108 or KPCI-3107 only"
' unload drivers for both controls
SRDO.Req_DLL_name = ""
SRCT.Req_DLL_name = ""
cmdStart.Enabled = False
Else
' if proper driver was loaded with success then setup the C/T
If (SRDO.Res_result = DL_NoErr) And (SRCT.Res_result = DL_NoErr) Then
cmdStart.Enabled = True  ' allow measurements to be asked for...
' set up CT channel 1 for 16bit event counting.
With SRCT
 .Req_subsystem = DL_CT
 .Req_mode = DL_POLLED
 .Req_op = DL_START
 .Evt_Tim_type = DL_RATEEVENT
 .Evt_Tim_rateChannel = 1  ' connect signal at pin 20
 .Evt_Tim_rateMode = DL_COUNT  ' 16bit event counting
 .Evt_Tim_rateClock = DL_EXTERNAL  ' counting external signal at pin 20
 .Evt_Tim_rateGate = HILEVELGATEN ' level gate signal from DO bit
 .Evt_Tim_ratePeriod = 0
 .Evt_Tim_rateOnCount = 0
 .Evt_Tim_ratePulses = 0  ' one time measurement
 .Evt_Tim_rateOutput = CT_Output_Default
 ' Other events, buffers, channels unneeded
 .Evt_Str_type = DL_NULLEVENT
 .Evt_Stp_type = DL_NULLEVENT
 .Sel_buf_N = 0
 .Sel_chan_N = 0
 End With
 End If  ' if no error
End If  ' if this is the KPCI3108 driver (for KPCI-3108 or KPCI-3107 boards)
End Sub

Private Sub cmdStart_Click()

' stop any active C/T task in order to reset the counter to zero
With SRCT
.Req_op = DL_STOP
.Refresh
.Req_op = DL_START  ' return it to a start operation
.Refresh            ' start it
End With
Dim i As Integer
Dim doBuffer(100) As Byte
Dim dummy As Long
Dim startVal As Byte
startVal = 1   'value to turn LSB to logic 1
' load the buffer with DO values
For i = 0 To 99
doBuffer(i) = startVal  ' loads all 100 points with a 1
Next i
'overwrite first and last values in array to logic 0
doBuffer(0) = 0
doBuffer(99) = 0
' the above results in a pulse on LSB of digital channel 0 at pin 24

With SRDO
.Req_op = DL_START
.Req_mode = DL_INTERRUPT
.Req_subsystem = DL_DO
.Evt_Str_type = DL_COMMAND
.Evt_Stp_type = DL_TCEVENT
' timing information
.Evt_Tim_type = DL_RATEEVENT
.Evt_Tim_rateChannel = DL_DEFAULTTIMER  ' default for DO subsystem is logical chan 2
.Evt_Tim_rateClock = DL_INTERNAL1  ' usually 5MHz timebase, controlled by DLinx Config
.Evt_Tim_rateGate = DL_DISABLED
.Evt_Tim_rateMode = DL_RATEGEN
.Evt_Tim_ratePeriod = .DLSecs2Tics(DL_DEFAULTTIMER, 1 / 200) ' 200 Hz
' DO will be at logic 1 for 98 tics.  Will be low for first and the last tic
' 98 tics results in 97 intervals at logic 1
' 97 x 200 Hz = 0.485 seconds pulse duration
' ***************************************************
' NOTE:  known bug.  At some rates for pacing the DO task which uses CT channel 2,
'        the event counting on CT channel 1 will be corrupted and always return value
'        of zero.  Operation at 200 Hz proved satisfactory when using 3108-850A04 driver.
'
' channel and number of samples info
.Sel_buf_N = 1
.Sel_buf_samples = 100  ' same size as doBuffer
.Sel_buf_notify = DL_NOTIFY  ' send buffer filled messages
.Sel_chan_N = 1
.Sel_chan_format = DL_tNATIVE
.Sel_chan_start = 0
.Sel_chan_startGainCode = 0  ' for DO, not really relevent
' move the doBuffer array to a memory buffer
dummy = .VBArrayBufferXfer(0, doBuffer, DL_VBArrayToBuffer)
.Refresh  ' write the buffer
End With

' witness the DO bit at pin 24

If SRDO.Res_result = DL_NoErr Then
lblDOStatus.Caption = "Starting DO task....."
Else
lblDOStatus.Caption = SRDO.Message
End If
lblStatus.Caption = SRDO.Message
End Sub

Private Sub Form_Load()
' Center form
  Me.Move (Screen.Width - Me.Width) / 2, (Screen.Height - Me.Height) / 2
  
  'populate list box with possible device numbers: 0..5
  cmbDevNum.AddItem "0", 0
  cmbDevNum.AddItem "1", 1
  cmbDevNum.AddItem "2", 2
  cmbDevNum.AddItem "3", 3
  cmbDevNum.AddItem "4", 4
  cmbDevNum.AddItem "5", 5
  
  
  
  
End Sub

Private Sub Form_Unload(Cancel As Integer)
' unload the driver for each SR control
SRDO.Req_DLL_name = ""
SRCT.Req_DLL_name = ""
Beep
End Sub

Private Sub SRDO_BufferFilled(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Integer)
lblDOStatus.Caption = " Digital Output Pulse has been written...."
End Sub

Private Sub SRDO_ServiceDone(task As Integer, device As Integer, subsystem As Integer, mode As Integer)
lblStatus.Caption = " Buffered DO task is done. "
' if the DO task is done, then gate signal is low again on the C/T
' time to read the C/T channel
txtRate.Text = ""  ' blank out last reading
With SRCT
.Res_Sta_typeStatus = DL_TIMERSTATUS  ' do staus op on the Timer
.Req_op = DL_STATUS
.Refresh
txtRate.Text = Format((.Res_Tim_count / 0.485), "#####0.#0")
' the counts at the C/T divided by time
End With
lblStatus.Caption = " Measurement is finished......"
End Sub
